#!/bin/bash

read -p "Network Optix Media Server will stop, do you need to continue? [Continue by pressing Y key,stop install by pressing other keys.]" input
        case $input in
                [yY])

                ;;
		*)
			exit 0  
		;;	
        esac

CONFIG_DIR="/opt/networkoptix/mediaserver/bin/msplugin_config"
CONFIG_FILE="$CONFIG_DIR/storage_config.json"
sudo mkdir -p "$CONFIG_DIR"
need_config=1
if [ -f "$CONFIG_FILE" ]; then

	read -p "storage_config.json already exists. Do you want to replace it? [Replace by pressing Y key, not replace by pressing other keys.]" replace
			case $replace in
					[yY])

					;;
			*)
        		echo "storage_config.json already exists. Skip replace."
				need_config=0
			;;	
			esac
fi
if [ "$need_config" -eq 1 ]; then
	sudo cp ./storage_config.json "$CONFIG_DIR"
fi
chmod 777 "$CONFIG_DIR"
chmod 777 "$CONFIG_FILE"


apt-get install -y libcurl4-openssl-dev zlib1g-dev libssl-dev

if [ -d "/opt/networkoptix/mediaserver/bin/plugins/milesight_config_plugin" ];then
	sudo rm -rf /opt/networkoptix/mediaserver/bin/plugins/milesight_config_plugin
fi
if [ -d "/opt/networkoptix/mediaserver/bin/plugins/milesight_storage_plugin" ];then
	sudo rm -rf /opt/networkoptix/mediaserver/bin/plugins/milesight_storage_plugin
fi

if [ -d "./milesight_config_plugin" ];then
	sudo mkdir -p /opt/networkoptix/mediaserver/bin/plugins/milesight_config_plugin
	sudo cp ./milesight_config_plugin/* /opt/networkoptix/mediaserver/bin/plugins/milesight_config_plugin/
fi
if [ -d "./milesight_storage_plugin" ];then
	sudo mkdir -p /opt/networkoptix/mediaserver/bin/plugins/milesight_storage_plugin
	sudo cp ./milesight_storage_plugin/* /opt/networkoptix/mediaserver/bin/plugins/milesight_storage_plugin/
fi

sudo systemctl restart networkoptix-mediaserver
